<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settings extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('sma');
        $this->load->library('encryption');
        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('settings', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function update() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $title = $this->input->post('title');
        $email = $this->input->post('email');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $currency = $this->input->post('currency');
		$discount = $this->input->post('discount'); 		//discount type added by shariat
        $facebook_id = $this->input->post('facebook_id');
        $logo = $this->input->post('logo');
        $buyer = $this->input->post('buyer');
        $p_code = $this->input->post('p_code');

        if (!empty($email)) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
            // Validating Name Field
            $this->form_validation->set_rules('name', 'System Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Title Field
            $this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Email Field
            $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Address Field    
            $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[1]|max_length[500]|xss_clean');
            // Validating Phone Field           
            $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[1]|max_length[50]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('currency', 'Currency', 'trim|required|min_length[1]|max_length[3]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('facebook_id', 'Facebook Page ID', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Logo Field   
            $this->form_validation->set_rules('logo', 'Logo', 'trim|min_length[1]|max_length[1000]|xss_clean');
            // Validating Department Field   
            $this->form_validation->set_rules('buyer', 'Buyer', 'trim|min_length[5]|max_length[500]|xss_clean');
            // Validating Phone Field           
            $this->form_validation->set_rules('p_code', 'Purchase Code', 'trim|min_length[5]|max_length[50]|xss_clean');

            if ($this->form_validation->run() == FALSE) {
                $data = array();
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('settings', $data);
                $this->load->view('home/footer'); // just the footer file
            } else {

                $file_name = $_FILES['img_url']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "1768",
                    'max_width' => "2024"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('img_url')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];
                    $data = array();
                    $data = array(
                        'system_vendor' => $name,
                        'title' => $title,
                        'address' => $address,
                        'phone' => $phone,
                        'email' => $email,
                        'currency' => $currency,
						'discount' => $discount, // added by shariat
                        'codec_username' => $buyer,
                        'codec_purchase_code' => $p_code,
                        'logo' => $img_url,
                        'facebook_id' => $facebook_id
                    );
                } else {
                    $data = array();
                    $data = array(
                        'system_vendor' => $name,
                        'title' => $title,
                        'address' => $address,
                        'phone' => $phone,
                        'email' => $email,
                        'discount' => $discount, // added by shariat
                        'codec_username' => $buyer,
                        'codec_purchase_code' => $p_code,
                        'facebook_id' => $facebook_id
                    );
                }

                $this->settings_model->updateSettings($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
                redirect('settings');
            }
        } else {
            $this->session->set_flashdata('feedback', lang('email_required'));
            redirect('settings', 'refresh');
        }
    }

    function backups() {
        $data['files'] = glob('./files/backups/*.zip', GLOB_BRACE);
        $data['dbs'] = glob('./files/backups/*.txt', GLOB_BRACE);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('backups', $data);
        $this->load->view('home/footer');
    }


    function backup_database() {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }        	
          $this->load->dbutil();
          $backup = $this->dbutil->backup();
          $this->load->helper('file');
          //write_file('Downloads.sql', $backup);
          $this->load->helper('download');
          $db_name = 'db-backup-on-' . date("Y-m-d-H-i-s") . '.zip';
          force_download($db_name, $backup); 
    }

    function backup_files() {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }
        $this->load->library('zip');
        $data = array_diff(scandir(FCPATH), array('..', '.', 'files')); // 'files' folder will be excluded here with '.' and '..'
        foreach ($data as $d) {
            $path = FCPATH . $d;
            if (is_dir($path))
                $this->zip->read_dir($path, false);
            if (is_file($path))
                $this->zip->read_file($path, false);
        }
        $filename = 'file-backup-' . date("Y-m-d-H-i-s") . '.zip';
        $this->zip->archive(FCPATH . 'files/backups/' . $filename);
        $this->session->set_flashdata('message', 'Application backup Successfull !');
        redirect("settings/backups");
        exit();
    }

    function restore_database($dbfile) {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }
        $file = file_get_contents('./files/backups/' . $dbfile . '.txt');
        $this->db->conn_id->multi_query($file);
        $this->db->conn_id->close();
        $this->session->set_flashdata('message', 'Restoring of Backup Successfull');
        redirect('settings/backups');
    }

    function download_database($dbfile) {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }
        $this->load->library('zip');
        $this->zip->read_file('./files/backups/' . $dbfile . '.txt');
        $name = 'db_backup_' . date('Y_m_d_H_i_s') . '.zip';
        $this->zip->download($name);
        exit();
    }

    function download_backup($zipfile) {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }
        $this->load->helper('download');
        force_download('./files/backups/' . $zipfile . '.zip', NULL);
        exit();
    }

    function restore_backup($zipfile) {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }
        $file = './files/backups/' . $zipfile . '.zip';
        $this->sma->unzip($file, './');
        $this->session->set_flashdata('info', 'Restoring of Application Successfull');
        redirect("settings/backups");
        exit();
    }

    function encrypt() {  
        $licence_date = $this->input->post("licence_date");
        if (!empty($licence_date))
        {
        $ciphertext = $this->encryption->encrypt(strtotime($licence_date));
        //echo $ciphertext; 
        $data['ciphertext']=$ciphertext;
        $data['licence_date']=$licence_date;
        }
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('encrypt_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

  

    function delete_database($dbfile) {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }
        unlink('./files/backups/' . $dbfile . '.txt');
        $this->session->set_flashdata('info', 'Deleting of Database Successfull');
        redirect("settings/backups");
    }

    function delete_backup($zipfile) {
        if (!$this->ion_auth->in_group('admin')) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect("home/permission");
        }
        unlink('./files/backups/' . $zipfile . '.zip');
        $this->session->set_flashdata('info', 'Deleting of App Backup Successfull');
        redirect("settings/backups");
    }

    function substring($index, $value) {

        foreach ($value as $key => $value2) {

            $value3 = trim(substr($value2, 2));
            $value4[] = substr($value3, 0, -2);
        }

        foreach ($index as $key => $index2) {

            $index3 = substr($index2, 7);
            $index4[] = substr($index3, 0, -3);
        }

        return array_combine($index4, $value4);
    }

    function languageEdit() {
        $id = $this->input->get('id');
        //load helper for language
        $this->load->helper('string');

        if ($id == 'arabic') {
            $path = APPPATH . 'language/arabic/system_syntax_lang.php';
        }
        if ($id == 'english') {
            $path = APPPATH . 'language/english/system_syntax_lang.php';
        }
        if ($id == 'italian') {
            $path = APPPATH . 'language/italian/system_syntax_lang.php';
        }
        if ($id == 'french') {
            $path = APPPATH . 'language/french/system_syntax_lang.php';
        }

        if ($id == 'spanish') {
            $path = APPPATH . 'language/spanish/system_syntax_lang.php';
        }
        if ($id == 'portuguese') {
            $path = APPPATH . 'language/portuguese/system_syntax_lang.php';
        }
        if ($id == 'russian') {
            $path = APPPATH . 'language/russian/system_syntax_lang.php';
        }
        if ($id == 'turkish') {
            $path = APPPATH . 'language/turkish/system_syntax_lang.php';
        } if ($id == 'japanese') {
            $path = APPPATH . 'language/japanese/system_syntax_lang.php';
        }
        if ($id == 'indonesian') {
            $path = APPPATH . 'language/indonesian/system_syntax_lang.php';
        }
        if ($id == 'zh_cn') {
            $path = APPPATH . 'language/zh_cn/system_syntax_lang.php';
        }
        $file = fopen($path, "r");
        $i = 0;
        while (!feof($file)) {
            $line = fgets($file);

            $arr = explode("=", $line, 2);
            if (!empty($arr[1])) {
                $index[$i] = $arr[0];
                $value[$i] = $arr[1];
                $i = $i + 1;
            }
        }
        fclose($file);



        $data = array();
        $data['languages'] = $this->substring($index, $value);

        $data['languagename'] = $id;



        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('edit_language', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function addLanguageTranslation() {
        $id = $this->input->post('language');

        $indexes = $this->input->post('indexupdate');
        $index = explode("#**##***", $indexes);
        $valueupdate = $this->input->post('valueupdate');

        $value = explode("*##**###", $valueupdate);

        foreach ($index as $key => $values) {
            if ($key !== 0) {

                $indexupdate[] = $values;
            }
        }

        foreach ($value as $key => $values) {
            if ($key !== 0) {
                $values = trim($values);
                $value2 = explode("'", $values);
                $length = count($value2);

                if (empty($value2[1])) {
                    //  echo $value
                    $valueupdated[] = $value2[0];
                } else {
                    $valuefinal = array();
                    foreach ($value2 as $keys => $value3) {


                        $lastChar = substr($value3, -1);
                        if (preg_match('/\\\\/', $lastChar)) {
                            $valuefinal[] = $value3 . "'";
                        } else {

                            if ($keys != ($length - 1)) {
                                $valuefinal[] = $value3 . "\'";
                            } else {
                                $valuefinal[] = $value3;
                            }
                        }
                    }
                    $valueconcate = "";
                    foreach ($valuefinal as $valuefinal) {
                        $valueconcate .= $valuefinal;
                    }
                    $valueupdated[] = $valueconcate;
                }
            }
        }



        $data = array();
        $data = array_combine($indexupdate, $valueupdated);

        if ($id == 'arabic') {
            $path = APPPATH . 'language/arabic/system_syntax_lang.php';
        }
        if ($id == 'english') {
            $path = APPPATH . 'language/english/system_syntax_lang.php';
        }
        if ($id == 'italian') {
            $path = APPPATH . 'language/italian/system_syntax_lang.php';
        }
        if ($id == 'french') {
            $path = APPPATH . 'language/french/system_syntax_lang.php';
        }
        if ($id == 'indonesian') {
            $path = APPPATH . 'language/indonesian/system_syntax_lang.php';
        }
        if ($id == 'zh_cn') {
            $path = APPPATH . 'language/zh_cn/system_syntax_lang.php';
        }
        if ($id == 'spanish') {
            $path = APPPATH . 'language/spanish/system_syntax_lang.php';
        }
        if ($id == 'portuguese') {
            $path = APPPATH . 'language/portuguese/system_syntax_lang.php';
        }
        if ($id == 'russian') {
            $path = APPPATH . 'language/russian/system_syntax_lang.php';
        }
        if ($id == 'turkish') {
            $path = APPPATH . 'language/turkish/system_syntax_lang.php';
        } if ($id == 'japanese') {
            $path = APPPATH . 'language/japanese/system_syntax_lang.php';
        }


        unlink($path);
        $option = "<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/**
 * Name:  Auth Lang -" . $id . "
 *
 * Author: Ben Edmunds
 * 		  ben.edmunds@gmail.com
 *         @benedmunds
 *
 * Author: Daniel Davis
 *         @ourmaninjapan
 *
 * Location: http://github.com/benedmunds/ion_auth/
 *
 * Created:  03.09.2013
 *
 * Description: " . $id . " language file for Ion Auth example views
 *
 */
// Errors";
        $file_handle = fopen($path, 'a+');
        fwrite($file_handle, $option);
        fwrite($file_handle, "\n");
        foreach ($data as $key => $value) {
            $valueupdate = trim($value);
            $option1 = '$lang' . "['" . $key . "'] = '$valueupdate';";
            fwrite($file_handle, $option1);
            fwrite($file_handle, "\n");
        }


        fclose($file_handle);
        $this->session->set_flashdata('feedback', lang('updated'));
        redirect('settings/language');
    }

    public function updateLicense() {
        $id = 1;
        $license = $this->input->post('license');

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
            $this->form_validation->set_rules('license', 'license', 'trim|required|min_length[1]|max_length[500]|xss_clean');
           
            if ($this->form_validation->run() == FALSE) {
                redirect('home/license');
            } else {                
                    $data = array();
                    $data = array(
                        'live_appointment_type' => $license,
                    );               
                $this->settings_model->updateSettings($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
                redirect('home');
            }
    }


}

/* End of file settings.php */
/* Location: ./application/modules/settings/controllers/settings.php */


