<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <section class="">
            <header class="panel-heading">
            <?php echo lang('load'); ?> <?php echo lang('inventory'); ?> <?php echo lang('list'); ?> (<span style="color:red"> <?php echo lang('inventory'); ?>: <?php echo $inventoryId; ?></span>) 
            </header>

            <style>
                .wrapper {
                    padding: 0px 10px 0px 15px !important;
                }
                .btn {
                    margin-top: 0px;
                }
            </style>

            <div class="panel-body"> 
                <div class="adv-table editable-table">
                    <div class="space15">
                    </div>
                    <table class="table table-striped table-hover table-bordered" id="editable-sample1">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo lang('name'); ?> & <?php echo lang('id'); ?></th>
                                <th><?php echo lang('quantity'); ?></th>
                                <th><?php echo lang('batch_no'); ?></th>
                                <th><?php echo lang('supplier'); ?></th>
                                <th><?php echo lang('expiry_date'); ?></th>
                                <th><?php echo lang('status'); ?></th>
                                <th><?php echo lang('remarks'); ?></th>
                                <th><?php echo lang('add'); ?> <?php echo lang('date'); ?></th>                               
                                <th><?php echo lang('added_by'); ?></th> 
                                <th><?php echo lang('options'); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                        <?php foreach ($inventorys as $inventory) { ?>
                            <tr class="">
                                <td><?php echo $inventory->id; ?></td>
                                <td><?php echo $inventory->name; ?></td>
                                <td><?php echo $inventory->quantity; ?></td>
                                <td><?php echo $inventory->batch_no; ?></td>
                                <td><?php echo $inventory->supplier; ?></td>
                                <td><?php 
                                    $today = time();
                                     $warningPeriod=floor(($inventory->e_date - $today)/(lang('month_calculation')));  //in months
                                     if ($warningPeriod<lang('inventory_expire_period'))
                                     $warning= '<br><em><span style="color:red">'.$warningPeriod. lang('inventory_expire_unit').'</span></em>';
                                     else 
                                     $warning='';
                                     echo date('d-M-Y', $inventory->e_date). ' ' . $warning; 
                                    ?>
                                </td>
                                <td> <?php echo $inventory->status; ?></td>
                                <td> <?php echo $inventory->remarks; ?></td>  
                                <td> <?php echo date('d-M-Y h:i A', $inventory->add_date); ?></td>
                                <td> <?php 
                                $user =  $inventory->user;
                                $userDetail = $this->db->get_where('users', array('id' => $user))->row();
                                echo $userDetail->username; 
                                ?>
                                </td>
                                <?php if ($this->ion_auth->in_group(array('admin','Accountant'))) { ?>   
                                <td><button type="button" class="btn btn-info btn-xs btn_width editbutton" data-toggle="modal" data-id="<?php echo $inventory->id; ?>"><i class="fa fa-edit"> </i> <?php echo lang('update_status'); ?></button>
                                <?php } ?>
                                <?php if ($this->ion_auth->in_group(array('admin'))) { ?>   
                                 <?php echo '<a class="btn btn-info btn-xs btn_width delete_button" href="inventory/deleteLoadInventory?id=' . $inventory->id . '" onclick="use confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i> ' . lang('delete') . '</a>'; ?>
                                </td>
                                <?php } ?>
                            </tr>
                        <?php } ?>


                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <!-- page end-->
    </section>
</section>
<!--main content end-->
<!--footer start-->


<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title">  <?php echo lang('update_status'); ?></h4>
            </div>
            <div class="modal-body row">
                <form role="form" id="editInventoryForm" class="clearfix" action="inventory/updateLoadInventory" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-7">
                        <label for="exampleInputEmail1"> <?php echo lang('inventory'); ?> <?php echo lang('name'); ?></label>
                        <input type="text" class="form-control" name="name" id="exampleInputEmail1" value='' placeholder="" readonly>
                    </div>
                    <div class="form-group col-md-7">
                        <label for="exampleInputEmail1"> <?php echo lang('batch_no'); ?></label>
                        <input type="text" class="form-control" name="batch_no" id="exampleInputEmail1" value='' placeholder="" readonly>
                    </div>

                    <div class="form-group col-md-7">
                        <label for="exampleInputEmail1"> <?php echo lang('status'); ?></label>
                        <select class="form-control m-bot15" name="status" value='' required>
                            <option value="<?php echo lang('inventory_batch_status_available') ?>"><?php echo lang('inventory_batch_status_available') ?></option>  
                            <option value="<?php echo lang('inventory_batch_status_sold') ?>"><?php echo lang('inventory_batch_status_sold') ?></option>                                         
                        </select>
                    </div>

                    <input type="hidden" name="id" value=''>
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info pull-right"> <?php echo lang('submit'); ?></button>
                    </div>
                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->


<script src="common/js/codearistos.min.js"></script>

<script type="text/javascript">
    $(document).ready(function () {
        $(".table").on("click", ".editbutton", function () {

            var iid = $(this).attr('data-id');
            $('#editInventoryForm').trigger("reset");
            $('#myModal2').modal('show');
            $.ajax({
                url: 'inventory/editLoadInventoryByJason?id=' + iid,
                method: 'GET',
                data: '',
                dataType: 'json',
            }).success(function (response) {
                // Populate the form fields with the data returned from server
                $('#editInventoryForm').find('[name="id"]').val(iid).end()
                $('#editInventoryForm').find('[name="name"]').val(response.inventory.name).end()
                $('#editInventoryForm').find('[name="batch_no"]').val(response.inventory.batch_no).end()
                $('#editInventoryForm').find('[name="status"]').val(response.inventory.status).end()
            });
        });
    });
</script>

<script>

    $(document).ready(function () {
        var table = $('#editable-sample1').DataTable({
            responsive: true,
            "processing": true,
            dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",
            buttons: [,
                'pdfHtml5',
                'excelHtml5',
                {
                    extend: 'print',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, 6,7,8],
                    }
                },
            ],
            aLengthMenu: [
                [10, 25, 50, 100],
                [10, 25, 50, 100]
            ],
            iDisplayLength: 25,
            "order": [0, "desc"],
            "language": {
                "lengthMenu": "_MENU_",
                search: "_INPUT_",
                searchPlaceholder: "Search...",
                "url": "common/assets/DataTables/languages/<?php echo $this->language; ?>.json"
            },
        });
        table.buttons().container().appendTo('.custom_buttons');
    });
</script>
<script>
    $(document).ready(function () {
        $(".flashmessage").delay(3000).fadeOut(100);
    });
</script>

